// sigusr2.c
//
// Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: The source file for sigusr2 process.
//

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <e32def.h>

/**
 The variable used in waiting for a signal iteration.
 */
int gVal = TRUE;

/**
 The custom handler function for SIGUSR2. 
 @param signum The signal number
 */
void SIGUSR2_handler(int signum)
    {
    if(signum == SIGUSR2)
        {
        printf("Received the SIGUSR2 signal from the sigusr1 process after reading the file.\n");
        gVal = FALSE;
        }
    }

/**
 Entry point for sigusr2 process.
 The sigusr2 process assigns a custom handler for the SIGUSR2 signal.
 It sends SIGUSR1 to the sigusr1 process by accepting a key press event from the user.
 Then it waits for the reception of a SIGUSR2 signal from the sigusr1 process.
 The process exits after the SIGUSR2 signal is obtained.
 */
int main(int argc,char **argv)
    {
    pid_t asyProcsID;
    char ch;
    int ret;
    if(argc < 2)
        {
        printf("Please pass the correct arguments\n");
        return EXIT_FAILURE;
        }
    asyProcsID = atoi(argv[1]);  //The variable holding the sigusr1 process PID.
    // Setup the custom handler for SIGUSR2.
    signal(SIGUSR2, SIGUSR2_handler);
    printf("******************** In the sigusr2 process ********************\n");
    
    printf("\nPress the Enter key to send the SIGUSR1 signal to the sigusr1 process\n");
    getchar();
    ret = kill(asyProcsID,SIGUSR1);
    if(ret)
        {
        printf("kill() failed to send signal, errno=%d\n",errno);
        gVal = FALSE;
        }
    
    /* 
     Waiting until a SIGUSR2 signal is obtained from the sigusr1 process.
     This signal is sent after the aynscFile.txt file has been
     read and its content written to the console.
    */
    while(gVal)
        {
        sleep(0);   //Initiates signal handling.
        }
    printf("\nPress 'e'+Enter to exit from the sigusr2 process\n");
    while((ch = getchar())!= 'e')
        {
        if(ch == '\n')
            continue;
        else
            printf("The wrong option was selected, please try again!!!\n");
        }
    return EXIT_SUCCESS;
    }
